#!/usr/bin/python
import os,sys
import random
import base64

infile = None
if len(sys.argv) < 3:
    sys.stderr.write("NO FILE NAME GIVEN NOR SEQUENCE TO SEARCH\n")
    sys.exit(1)
else:
    infile = sys.argv[1]
    seqs   = sys.argv[2:]

if not os.path.exists(infile):
    sys.stderr.write("INPUT FILE %s DOES NOT EXISTS\n" % infile)
    sys.exit(2)

#seqs = [
#"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA",
#"TTTTTTTTTCTTTTCACAATAACAAAAAAAAA", #dup
##"AAAAAAAAAAAAAAAAAAAAAAAAAAACACCC",
##"AAAAAAAAAAAAAAAAAAAAAAAAAAACTTTT",
##"AAAAAAAAAAAAAAAAAAAAAAAAAACGAAAC",
##"AAAAAAAAAAAAAAAAAAAAAAAAAACTAGTA",
##"AAAAAAAAAAAAAAAAAAAAAAAAAAGCTAAA",
##"AAAAAAAAAAAAAAAAAAAAAAAACAAAAAAA",
##"AAAAAAAAAAAAAAAAAAAAAAAACCCAAAAG",
##"AAAAAAAAAAAAAAAAAAAAAAAACTTCGAAC",
##"AAAAAAAAAAAAAAAAAAAAAAAAGAAGAAGC",
##"AAAAAAAAAAAAAAAAAAAAAAACAGAAGTTA",
##"AAAAAAAAAAAAAAAAAAAAAAACAGACACAC",
##"AAAAAAAAAAAAAAAAAAAAAAACCTTGGCAG",
##"AAAAAAAAAAAAAAAAAAAAAAACTATCCTTG",
##"AAAAAAAAAAAAAAAAAAAAAAAGAGTATTTG",
##"AAAAAAAAAAAAAAAAAAAAAAAGATATATTA",
##"AAAAAAAAAAAAAAAAAAAAAAAGCGGAACTT",
##"AAAAAAAAAAAAAAAAAAAAAAATAAGTACCA",
##"AAAAAAAAAAAAAAAAAAAAAAATCTTAGGCA",
##"AAAAAAAAAAAAAAAAAAAAAACCTACTCATA",
##"AAAAAAAAAAAAAAAAAAAAAACTCGAAACCA",
##"AAAAAAAAAAAAAAAAAAAAAACTGAAAACAT",
##"AAAAAAAAAAAAAAAAAAAAAACTTCAACAAC",
##"AAAAAAAAAAAAAAAAAAAAAAGAAGAGAGAG",
##"AAAAAAAAAAAAAAAAAAAAAAGAGGGGTTCA",
##"AAAAAAAAAAAAAAAAAAAAAAGAGGTCTTAA",
##"AAAAAAAAAAAAAAAAAAAAACACATGTCTTT",
##"AAAAAAAAAAAAAAAAAAAAACTCAAAACCAA",
##"AAAAAAAAAAAAAAAAAAAAACTGAATCTTGG",
##"AAAAAAAAAAAAAAAAAAAAACTTTCTATAAG",
##"AAAAAAAAAAAAAAAAAAAAAGAATTAATACC",
##"AAAAAAAAAAAAAAAAAAAAAGAGAGAGAGAA",
##"AAAAAAAAAAAAAAAAAAAAAGAGAGGCCAAA",
##"AAAAAAAAAAAAAAAAAAAAAGGGGGAAAAAC",
##"AAAAAAAAAAAAAAAAAAAAAGGTGATGGTCC",
##"AAAAAAAAAAAAAAAAAAAAAGTATATCAAAT",
##"AAAAAAAAAAAAAAAAAAAAATCACTTGAAGG",
##"AAAAAAAAAAAAAAAAAAAAATTTACCATCCA",
##"AAAAAAAAAAAAAAAAAAAACCAATTGTATCT",
##"AAAAAAAAAAAAAAAAAAAACGCCCAACTCCA",
##"AAAAAAAAAAAAAAAAAAAACTAACTCAACGC",
##"AAAAAAAAAAAAAAAAAAAACTAGTATTATAG",
##"AAAAAAAAAAAAAAAAAAAACTAGTTATGTTA",
##"AAAAAAAAAAAAAAAAAAAACTGAGAGCTTGA",
##"AAAAAAAAAAAAAAAAAAAAGAAAACTCCAGC",
##"AAAAAAAAAAAAAAAAAAAAGTGAAACTATTT",
##"AAAAAAAAAAAAAAAAAAAAGTTACCTTCGTA",
##"AAAAAAAAAAAAAAAAAAAAGTTGATCCCAGG",
##"AAAAAAAAAAAAAAAAAAAATCTAGGCCACGT",
##"AAAAAAAAAAAAAAAAAAAATCTTCAAGTTAA",
##"AAAAAAAAAAAAAAAAAAAATGGCTTTTAATT",
##"AAAAAAAAAAAAAAAAAAAATTTACAGCGTCG",
##"AAAAAAAAAAAAAAAAAAACATAAAACACGAC",
##"AAAAAAAAAAAAAAAAAAACTATAGCTTATCG",
##"AAAAAAAAAAAAAAAAAAACTTGATATATAGT",
##"AAAAAAAAAAAAAAAAAAACTTGCAAATGTTG",
##"AAAAAAAAAAAAAAAAAAACTTTTATCAAGCT",
##"AAAAAAAAAAAAAAAAAAAGAAAGAAACAATT",
##"AAAAAAAAAAAAAAAAAAAGAAGAAGATAAAA",
##"AAAAAAAAAAAAAAAAAAAGAGGGAAATTATT",
##"AAAAAAAAAAAAAAAAAAAGAGGTGGATATAT",
##"AAAAAAAAAAAAAAAAAAAGAGGTTATGAAAA",
##"AAAAAAAAAAAAAAAAAAAGCAAACAAAAAAA",
##"AAAAAAAAAAAAAAAAAAAGCAAAGTCTCCAT",
##"AAAAAAAAAAAAAAAAAAAGGAAAGAAAATGT",
##"AAAAAAAAAAAAAAAAAAAGGAGACACCCTAC",
##"AAAAAAAAAAAAAAAAAAAGGAGATTTCCACG",
##"AAAAAAAAAAAAAAAAAAATATATATATATAT",
##"AAAAAAAAAAAAAAAAAAATCAAAATACTTGT",
##"AAAAAAAAAAAAAAAAAAATCTGTTTTTTTTT",
##"AAAAAAAAAAAAAAAAAAATTAAAAAATGGAA",
##"AAAAAAAAAAAAAAAAAAATTAAACTAAAAAA",
##"AAAAAAAAAAAAAAAAAAATTAGCGGCGAGAG",
##"AAAAAAAAAAAAAAAAAACACAACTCATACAT",
##"AAAAAAAAAAAAAAAAAACACCATAAGCCATC",
##"AAAAAAAAAAAAAAAAAACAGGCGTGGCGAAA",
##"AAAAAAAAAAAAAAAAAACAGTAAAAGCAAAC",
##"AAAAAAAAAAAAAAAAAACAGTATAACGGCTA",
##"AAAAAAAAAAAAAAAAAACCACCACATTCATA",
##"AAAAAAAAAAAAAAAAAACCATAGTGATACCG",
##"AAAAAAAAAAAAAAAAAACCGACACACTTTTA",
##"AAAAAAAAAAAAAAAAAACCTTTTTCAAGTTT",
##"AAAAAAAAAAAAAAAAAACTAAAACAAGAGAA",
##"AAAAAAAAAAAAAAAAAACTACTTGGGTTCAA",
##"AAAAAAAAAAAAAAAAAACTTAATAGGATCAA",
##"AAAAAAAAAAAAAAAAAACTTATTACTAGTTC",
##"AAAAAAAAAAAAAAAAAACTTGAAAGCACCTC",
##"AAAAAAAAAAAAAAAAAAGAACCCCACACGCA",
##"AAAAAAAAAAAAAAAAAAGAACTATTCAAAAG",
##"AAAAAAAAAAAAAAAAAAGAAGAGAAATGGGG",
##"AAAAAAAAAAAAAAAAAAGAGAGAAGGAGAAG",
##"AAAAAAAAAAAAAAAAAAGATAATGAAAAAAA",
##"AAAAAAAAAAAAAAAAAAGCCATATTTACATT",
##"AAAAAAAAAAAAAAAAAAGCTCAACAAGGCTT",
##"AAAAAAAAAAAAAAAAAAGGACATTGGCCGGA",
##"AAAAAAAAAAAAAAAAAATATATATATATATA",
##"AAAAAAAAAAAAAAAAAATCAGAAGAGATTGC",
##"AAAAAAAAAAAAAAAAAATCTGCAAAGTCATA",
##"AAAAAAAAAAAAAAAAAATTAAAAAAATGCAA",
#"AAAAAAAAAAAAAAAAAATTACCAAGGCAAAC",
#"AAAAAAAAAAAAAAAAAATTACCAAGGCAAAA", #wrong
#"TTTTTTTAATTGTACAAAAAAACAAAAAAAAA",
#"TTTTTTTACAAGGGAAATCCCATTCAAAAAAA",
##"TTTTTTTACAAGTTCACAAGGGACCAAAAAAA",
##"TTTTTTTACACCTACTACTATATCGAAAAAAA",
##"TTTTTTTACACTAAAGAATGAAAGAAAAAAAA",
##"TTTTTTTACCTCCCAACAATAATATAAAAAAA",
##"TTTTTTTAGAAAAAAAAAGTTTTGAAAAAAAA",
##"TTTTTTTAGGTAGAGAGTAGTCATAAAAAAAA",
##"TTTTTTTAGTAATGAAATATTAAATAAAAAAA",
##"TTTTTTTAGTGTTTGGTAAATAAGAAAAAAAA",
##"TTTTTTTAGTTCATTCTATTGTTCAAAAAAAA",
##"TTTTTTTAGTTTGAATCCTTAACCAAAAAAAA",
##"TTTTTTTATAATGAATAAACAGACAAAAAAAA",
##"TTTTTTTATAATTGAGTAGTTACAAAAAAAAA",
##"TTTTTTTATAATTTTTAAATATGATAAAAAAA",
##"TTTTTTTATAATTTTTTTTTTTTAAAAAAAAA",
##"TTTTTTTATATTATCAAATCAGTCAAAAAAAA",
##"TTTTTTTATCGAATATGACAGTTTAAAAAAAA",
##"TTTTTTTATCTCTTCAAATAGAAAAAAAAAAA",
##"TTTTTTTATCTTGTGTTATACTATGAAAAAAA",
##"TTTTTTTATGCAAACAAAGAATCCAAAAAAAA",
##"TTTTTTTATGGTGACATAAAATGGAAAAAAAA",
##"TTTTTTTATGTCATCCATTAGTGTAAAAAAAA",
##"TTTTTTTATTAAAATCCACAAAAACAAAAAAA",
##"TTTTTTTATTAACTTATTTATGAGGAAAAAAA",
##"TTTTTTTATTACGTGCTAATTTATAAAAAAAA",
##"TTTTTTTATTCATTTCTTTTTTTTAAAAAAAA",
##"TTTTTTTATTTCATATTTTTGGTTGAAAAAAA",
##"TTTTTTTATTTGAAAAAAAAATCACAAAAAAA",
##"TTTTTTTCAAAAAAATATTTCATAAAAAAAAA",
##"TTTTTTTCAAAAATTTCATATCACAAAAAAAA",
##"TTTTTTTCAAATCTCAATTTTCAAAAAAAAAA",
##"TTTTTTTCAATCTGTTAAACCAAAAAAAAAAA",
##"TTTTTTTCAATTTGAAATTGTTTTAAAAAAAA",
##"TTTTTTTCACACCTGGCATACACTAAAAAAAA",
##"TTTTTTTCACATTTTATTCTCTTAAAAAAAAA",
##"TTTTTTTCCACCTATCATTTAGTTCAAAAAAA",
##"TTTTTTTCCATGTTTACCATCATCCAAAAAAA",
##"TTTTTTTCCGTGAGATTGGAGGGAGAAAAAAA",
##"TTTTTTTCGGAAAAACATAAATTTAAAAAAAA",
##"TTTTTTTCGTTTTCTTTTTTTTTAAAAAAAAA",
##"TTTTTTTCTAAATATTTTATTAAGAAAAAAAA",
##"TTTTTTTCTAAGGAACACACGCACAAAAAAAA",
##"TTTTTTTCTAATTCATCCACAGTAAAAAAAAA",
##"TTTTTTTCTCCAAACATTTTTTTTAAAAAAAA",
##"TTTTTTTCTCGATATGAAAAACGAAAAAAAAA",
##"TTTTTTTCTCGATCTGAAAAAATGAAAAAAAA",
##"TTTTTTTCTCGATCTGAAAAATGAAAAAAAAA",
##"TTTTTTTCTCTTGAAATTCCACAAAAAAAAAA",
##"TTTTTTTCTGAAGAACACACGCACAAAAAAAA",
##"TTTTTTTCTGCAAACAAAAACTTAAAAAAAAA",
##"TTTTTTTCTTCTTTGTTATGCTATAAAAAAAA",
##"TTTTTTTCTTTCATTCCTTAGTTTAAAAAAAA",
##"TTTTTTTCTTTTTTTTTTTACAAAAAAAAAAA",
##"TTTTTTTGAAAGTTTCTTTGTCCAAAAAAAAA",
##"TTTTTTTGAAATTGGTTTCACAGCAAAAAAAA",
##"TTTTTTTGAAATTTCCATATTTTAAAAAAAAA",
##"TTTTTTTGAGAAGATCTTTTTTAAAAAAAAAA",
##"TTTTTTTGCGATTTTATTTTGAGAAAAAAAAA",
##"TTTTTTTGGAAAAACATAAATTTTAAAAAAAA",
##"TTTTTTTGGAATTCTTAAGAAAGGAAAAAAAA",
##"TTTTTTTGGAGGGGGGGAGGCGATAAAAAAAA",
##"TTTTTTTGGATGAAAACTCCATTAAAAAAAAA",
##"TTTTTTTGGGAAAAACATCGATTTAAAAAAAA",
##"TTTTTTTGGTGATAAAGGGTTCCAAAAAAAAA",
##"TTTTTTTGGTTTTTCAAAATCAAAAAAAAAAA",
##"TTTTTTTGTAATAAGAAAATCATAAAAAAAAA",
##"TTTTTTTGTATATTACATTTTTTTAAAAAAAA",
##"TTTTTTTGTCTGCCAACAGAGCCAAAAAAAAA",
##"TTTTTTTGTGTAGCTTGTAGAAAGAAAAAAAA",
##"TTTTTTTGTTGTGTAACTTTTCATAAAAAAAA",
##"TTTTTTTGTTTTCTTCTTTCTATTAAAAAAAA",
##"TTTTTTTTAAAAAAAATATAATTAAAAAAAAA",
##"TTTTTTTTAAAAAATTAGGTTTTAAAAAAAAA",
##"TTTTTTTTAAAAATATATTGAGAGAAAAAAAA",
##"TTTTTTTTAAACTGACTAAAAGAAAAAAAAAA",
##"TTTTTTTTAAATTGACGTTTTCCCAAAAAAAA",
##"TTTTTTTTAAATTGATGTTTTTCCAAAAAAAA",
##"TTTTTTTTAAATTGTTGTTTTTTCAAAAAAAA",
##"TTTTTTTTAAGTTACCAGTTTCAAAAAAAAAA",
##"TTTTTTTTAATTTAATAAATGGTAAAAAAAAA",
##"TTTTTTTTAGAGAGAGAAAGGAAGAAAAAAAA",
##"TTTTTTTTAGATTTTATTTCACAAAAAAAAAA",
##"TTTTTTTTATAGCCTATACACCTGAAAAAAAA",
##"TTTTTTTTATGTGTTTTTTTTTTAAAAAAAAA",
##"TTTTTTTTATTTCTATAAAATTAAAAAAAAAA",
##"TTTTTTTTCGTTTTTCAGATCGAGAAAAAAAA",
##"TTTTTTTTCTCTTCATTTTTTGTAAAAAAAAA",
##"TTTTTTTTCTTCAAAAATATTATAAAAAAAAA",
##"TTTTTTTTGAAAATTTTTTTTTTAAAAAAAAA",
##"TTTTTTTTGAAATTGAACTCTGAAAAAAAAAA",
##"TTTTTTTTGACAAAATTTCAAAAAAAAAAAAA",
##"TTTTTTTTGCATAAAGGTCATTTAAAAAAAAA",
##"TTTTTTTTTAATATCCATACATTAAAAAAAAA",
##"TTTTTTTTTACAAAAAAATGAAGAAAAAAAAA",
##"TTTTTTTTTACTTCTACTTTATCAAAAAAAAA",
##"TTTTTTTTTATCTTTAACAAAAAAAAAAAAAA",
##"TTTTTTTTTCTTTTCACAACCAAAAAAAAAAA",
##"TTTTTTTTTCTTTTCACAATAACAAAAAAAAA",
#"TTTTTTTTTGATTTTTCAAATACAAAAAAAAA",
#"AAAAAAAAAAAAAAAAAAAAAAAAAAACACCC",#dup
#]




fileSize = os.path.getsize(infile)
print "FILE NAME:",infile
print "FILE SIZE:",fileSize
print "SEQs     :",seqs

first   = None
last    = None
lastPos = None
length  = None

with open(infile, 'r') as f:
    first = f.readline().strip().split()[0]

    f.seek(fileSize - 500)

    for line in f:
        last    = line.strip().split()[0]
        lastPos = f.tell() - len(line) + 1
        #print "LAST",last

    length = len(first.split()[0])
    print "  FIRST    '%s'" % first
    print "  LAST     '%s'" % last
    print "  LAST POS '%s'" % lastPos
    print "  LENGTH   '%d'" % length


    if first == last:
        sys.stderr.write("ONLY ONE LINE")
        sys.exit(3)

    if length != len(last.split()[0]):
        sys.stderr.write("KEY LENGTH DIFFERS")
        sys.exit(4)

    stack = {}

    for seq in seqs:
        #print "SEQ  ",seq
        f.seek(0)
        left     = 0
        right    = lastPos
        key      = None
        value    = -1
        leftKey  = None
        rightKey = None

        if len(stack) > 0:
            stackKeys = stack.keys()
            stackKeys.sort()
            for k in stackKeys:
                #print "  STACK ",k
                if k < seq:
                    left  = stack[k]
                    #print "    NEW LEFT ",left
                elif k > seq:
                    right = stack[k]
                    #print "    NEW RIGHT",right
                    break
            #print "    LEFT %d RIGHT %d" % (left, right)
            if left != 0:
                f.seek(left)
                #f.readline()
                leftKey = f.readline().strip().split()[0]
            if right != lastPos:
                f.seek(right)
                #f.readline()
                rightKey = f.readline().strip().split()[0]



        while len(stack) > 100:
            try:
                item = stack.popitem()
            except:
                print "error poping"
                sys.exit(1)
            #print "  POPING",item,"LEN",len(stack)



        if   seq == first:
            f.seek(left)
            line  = f.readline()
            #print "  LINE '",line,"'"
            value = line.strip().split()[1]

        elif seq == last:
            f.seek(lastPos)
            line  = f.readline()
            #print "  LINE '",line,"'"
            value = line.strip().split()[1]

        elif seq == leftKey:
            f.seek(left)
            line  = f.readline()
            #print "  LINE '",line,"'"
            value = line.strip().split()[1]

        elif seq == rightKey:
            f.seek(right)
            line  = f.readline()
            #print "  LINE '",line,"'"
            value = line.strip().split()[1]

        else:
            while key != seq and left <= right:
                mid = (left + right) / 2
                if mid == left and mid == right:
                    #print "  left %d and right %d == mid %d. breaking" % (left, right, mid)
                    break
                #
                #else:
                #print "  SEEKING MID",mid
                f.seek(mid)
                currPosPre   = f.tell()
                #print "  MID FOUND",mid

                currPosBegin = f.tell()
                line         = f.readline().strip()
                #print "  LINE1",line

                if line.find("\t") == -1:
                    currPosBegin = f.tell()
                    line         = f.readline().strip()
                    #print "  LINE2",line

                key,value    = line.split()
                if len(key) != length:
                    currPosBegin = f.tell()
                    line         = f.readline().strip()
                    #print "  LINE3",line
                    key,value    = line.split()

                currPosEnd   = f.tell()

                #print "    LEFT %d RIGHT %d MID %d CURR PRE %d CURR BEGIN %d CURR END %d VALUE %s\n\t\tKEY %s\n\t\tSEQ %s" % \
                #(left, right, mid, currPosPre, currPosBegin, currPosEnd, value, key, seq)

                if currPosEnd >= right:
                    #print "    curr pos end %d >= right %d. reducing" % (currPosEnd, right)
                    right = currPosPre
                    continue
                    #break

                if seq > key:
                    left       = currPosBegin
                    stack[key] = left
                    #print "    SEQUENCE > KEY. LEFT",left,"\n"

                else:
                    right      = currPosEnd
                    stack[key] = right
                    #print "    SEQUENCE < KEY. RIGHT",right,"\n"

            if key != seq:
                value = None

        if value is not None:
            print "  KEY %s VALUE %s\n\n\n" % (seq, value)
            v     = base64.b64decode(value)
